<?php
/**
 * Plugin Name: Aigentic – AI Manifest & Bot Optimizer
 * Plugin URI:  https://ikaros.pro/aigentic/
 * Description: Transforms WooCommerce into an "Agent-Ready" store. Connects Google Gemini to generate high-density AI product data for Shopping Bots.
 * Version:     1.0.0
 * Author:      Ikaros
 * Author URI:  https://ikaros.pro
 * License:     GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: aigentic
 * Requires at least: 5.8
 * Requires PHP: 7.4
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define Constants
define( 'AIGENTIC_VERSION', '1.0.0' );
define( 'AIGENTIC_PATH', plugin_dir_path( __FILE__ ) );
define( 'AIGENTIC_URL', plugin_dir_url( __FILE__ ) );

// Include Classes
require_once AIGENTIC_PATH . 'includes/class-admin-controller.php';
require_once AIGENTIC_PATH . 'includes/class-bot-bridge.php';
require_once AIGENTIC_PATH . 'includes/class-manifest-server.php';
require_once AIGENTIC_PATH . 'includes/class-frontend.php';
require_once AIGENTIC_PATH . 'includes/class-schema-handler.php';

// Initialize
function aigentic_init() {
    new Aigentic_Admin_Controller();
    new Aigentic_Bot_Bridge();
    new Aigentic_Manifest_Server(); // This enables the JSON Manifest
    new Aigentic_Frontend();        // This enables Meta Tags
    new Aigentic_Schema_Handler();
}
add_action( 'plugins_loaded', 'aigentic_init' );

// Activation Hook (Create DB Table)
register_activation_hook( __FILE__, 'aigentic_activate' );

function aigentic_activate() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'aigentic_bot_logs';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        bot_name varchar(50) NOT NULL,
        user_agent text NOT NULL,
        endpoint_accessed text NOT NULL,
        visit_time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
        PRIMARY KEY  (id)
    ) $charset_collate;";

    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
    dbDelta( $sql );
}

/**
 * Add Settings Link
 */
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'aigentic_add_action_links' );

function aigentic_add_action_links( $links ) {
    $settings_link = '<a href="' . esc_url( admin_url( 'admin.php?page=aigentic' ) ) . '">' . esc_html__( 'Settings', 'aigentic' ) . '</a>';
    $pro_link      = '<a href="https://ikaros.pro/product/aigentic-pro-plugin-add-on/" target="_blank">' . esc_html__( 'Upgrade to Pro &rarr;', 'aigentic' ) . '</a>';

    array_unshift( $links, $settings_link, $pro_link );
    return $links;
}


