jQuery(document).ready(function ($) {

    // 1. SAVE LANGUAGE BUTTON (This was missing!)
    $('#aigentic-save-lang').on('click', function (e) {
        e.preventDefault();
        var btn = $(this);
        var originalText = btn.text();
        var lang = $('#aigentic_target_language').val();

        btn.text('Saving...').prop('disabled', true);

        $.ajax({
            url: aigentic_vars.ajax_url,
            type: 'POST',
            data: {
                action: 'aigentic_save_language',
                language: lang,
                nonce: aigentic_vars.nonce
            },
            success: function (res) {
                if (res.success) {
                    btn.text('Saved!');
                    setTimeout(function () {
                        btn.text(originalText).prop('disabled', false);
                    }, 2000);
                } else {
                    alert('Error: ' + (res.data || 'Unknown error'));
                    btn.text(originalText).prop('disabled', false);
                }
            },
            error: function () {
                alert('Connection failed');
                btn.text(originalText).prop('disabled', false);
            }
        });
    });

    // 2. TEST BUTTON
    $('#aigentic-test-api').on('click', function (e) {
        e.preventDefault();

        let btn = $(this);
        let key = $('#aigentic_gemini_key').val();
        let feedback = $('#aigentic-api-feedback');

        if (!key) { alert('Please enter an API Key'); return; }

        btn.text('Auto-Detecting Model...').prop('disabled', true);
        feedback.html('');

        $.ajax({
            url: aigentic_vars.ajax_url,
            type: 'POST',
            data: {
                action: 'aigentic_verify_gemini',
                api_key: key,
                nonce: aigentic_vars.nonce
            },
            success: function (res) {
                console.log('Handshake Result:', res);
                if (res.success) {
                    feedback.html('<span style="color:green">✅ ' + res.data + '</span>');
                    setTimeout(function () { location.reload(); }, 1500); // Reload to show model name
                } else {
                    feedback.html('<span style="color:red">❌ ' + (res.data || 'Unknown Error') + '</span>');
                }
            },
            error: function (xhr) {
                console.error('Handshake Error:', xhr);
                feedback.html('<span style="color:red">Server Error: Check Console</span>');
            },
            complete: function () {
                btn.text('Save & Test').prop('disabled', false);
            }
        });
    });

    // 3. GENERATE BUTTON
    $('#aigentic-gen-btn').on('click', function (e) {
        e.preventDefault();
        let btn = $(this);
        let box = $('#_aigentic_ai_summary');

        btn.text('Thinking...').prop('disabled', true);

        $.ajax({
            url: aigentic_vars.ajax_url,
            type: 'POST',
            data: {
                action: 'aigentic_generate_summary',
                product_id: $('#post_ID').val(),
                nonce: aigentic_vars.nonce
            },
            success: function (res) {
                console.log('Generate Result:', res);
                if (res.success) {
                    box.val(res.data.summary);
                } else {
                    alert('Error: ' + (res.data || 'Unknown AI Error'));
                }
            },
            error: function (xhr) {
                console.error('Generate Error:', xhr);
                alert('Server Connection Failed');
            },
            complete: function () {
                btn.text('Generate with Gemini AI').prop('disabled', false);
            }
        });
    });

});