<?php
/**
 * Class Aigentic_Frontend
 * Injects AI-Readable Metadata into the storefront.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Aigentic_Frontend {

    public function __construct() {
        // 1. Add Meta Tag to Header
        add_action( 'wp_head', [ $this, 'inject_ai_meta_tags' ] );
        
        // 2. Add Invisible "Context Block" for older bots (optional but recommended)
        add_action( 'woocommerce_single_product_summary', [ $this, 'inject_hidden_context' ], 60 );
    }

    /**
     * Outputs <meta name="ai-context" content="...">
     * This is the cleanest way for modern AI agents to read the data.
     */
    public function inject_ai_meta_tags() {
        if ( ! is_product() ) return;

        global $post;
        $summary = get_post_meta( $post->ID, '_aigentic_ai_summary', true );

        if ( ! empty( $summary ) ) {
            echo "\n\n";
            echo '<meta name="ai-context" content="' . esc_attr( $summary ) . '" />' . "\n";
            echo '<meta name="ai-generated" content="true" />' . "\n";
            echo "\n";
        }
    }

    /**
     * Outputs a hidden div with the summary.
     * Useful for bots that only read the <body> content.
     */
    public function inject_hidden_context() {
        global $post;
        $summary = get_post_meta( $post->ID, '_aigentic_ai_summary', true );

        if ( ! empty( $summary ) ) {
            echo '<div class="aigentic-context" style="display:none;" data-role="ai-description">';
            echo esc_html( $summary );
            echo '</div>';
        }
    }
}