<?php
/**
 * Class Aigentic_Schema_Handler
 * Injects AI Data into the EXISTING WooCommerce Schema.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Aigentic_Schema_Handler {

    public function __construct() {
        // Filter WooCommerce's generated Schema
        add_filter( 'woocommerce_structured_data_product', [ $this, 'enrich_product_schema' ], 20, 2 );
    }

    /**
     * Modifies the JSON-LD before it is printed.
     */
    public function enrich_product_schema( $markup, $product ) {
        // 1. Get the AI Description
        $ai_summary = get_post_meta( $product->get_id(), '_aigentic_ai_summary', true );

        if ( ! empty( $ai_summary ) ) {
            // 2. ENHANCE DESCRIPTION
            // We put the AI summary first because bots read top-down.
            // We keep the old description as secondary context.
            $original_desc = isset($markup['description']) ? $markup['description'] : '';
            $markup['description'] = $ai_summary . ' ' . $original_desc;
            
            // 3. ADD ROBOT-SPECIFIC FIELDS
            $markup['disambiguatingDescription'] = $ai_summary; // Explicitly for machines
            $markup['keywords'] = 'AI Optimized, ' . $product->get_name();
            $markup['aigentic_optimized'] = true; // Custom signal
        }

        return $markup;
    }
}